import QtQuick 2.12

Rectangle {
    color: Qt.rgba(0.5,0.5,0.5,0.75)
    id: root
    signal accepted()
    signal rejected()
    property alias title: titleText.text
    property alias text: mainText.text
    anchors.fill: parent

    MouseArea {
        anchors.fill: parent
    }

    Rectangle {
        id: background
        color: "lightgrey"
        anchors.centerIn: parent
        width: Math.max(titleText.paintedWidth +12, mainText.paintedWidth +12)
        height: parent.height * .6
        Rectangle {
            id: titleBar
            color: "grey"
            anchors.top: parent.top
            anchors.left: parent.left
            anchors.right: parent.right
            height: parent.height * .25
            Text{
                id: titleText
                anchors.fill: parent
                anchors.leftMargin: 6
                anchors.rightMargin: 6
                font.pixelSize: parent.height * 0.75
            }
        }

        Text {
            id: mainText
            anchors.left: parent.left
            anchors.right: parent.right
            anchors.top: titleBar.bottom
            anchors.bottom: btnNo.top
            font.pixelSize: height * 0.3
            verticalAlignment: Text.AlignVCenter
        }
        Button {
            id: btnYes
            anchors.bottom: parent.bottom
            anchors.left: parent.left
            width: parent.width * .5
            height: parent.height * 0.15
            text: "Yes"
            onClicked: {
                root.accepted()
                root.visible = false
            }
        }

        Button {
            id: btnNo
            anchors.bottom: parent.bottom
            anchors.right: parent.right
            width: parent.width * .5
            height: parent.height * 0.15
            text: "No"
            onClicked: {
                root.rejected()
                root.visible = false
            }
        }
    }
}
